import sys
from sklearn.metrics import f1_score, precision_score, recall_score

triplet = []

f = open(sys.argv[1],'r')
while True:
	line = f.readline()
	if not line: break
	term = line.split(',')
	src = int(term[0])
	dst = int(term[1])
	lab = -1
	if term[2] == 'n\n':
		lab = 1
	elif term[2] == 's\n':
		lab = 2
	else:
		lab = 3
	triplet.append([src, dst, lab])
f.close()
print('#Triplet: ' + str(len(triplet)))


f_e = open('entity2vec','r')
entity_vec = {}
id_cnt = 0
while True:
	line = f_e.readline()
	if not line: break
	term = line.split('	')
	term = term[0:len(term)-1]
	term = [float(x) for x in term]
	entity_vec[id_cnt] = term
	id_cnt = id_cnt + 1
f_e.close()

f_r = open('relation2vec','r')
relation_vec = {}
id_cnt = 0
while True:
	line = f_r.readline()
	if not line: break
	term = line.split('	')
	term = term[0:len(term)-1]
	term = [float(x) for x in term]
	id_cnt = id_cnt + 1
	relation_vec[id_cnt] = term
f_r.close()

fid = open('result.txt','w')
print('TEST...')
estimate = []
answer = []
confusion = [[0] * 4 for _ in range(4)]
cnt = 0
for t in triplet:
	cnt = cnt + 1
	src = t[0]
	dst = t[1]
	rel = t[2]
	min_loss = 10000000000
	est_rel = 0
	for r in range(1,4):	
		loss = [x + y for x, y in zip(entity_vec[src], relation_vec[r])]
		loss = [x - y for x, y in zip(loss, entity_vec[dst])]
		loss = abs(sum(loss))
		if loss < min_loss:
			min_loss = loss
			est_rel = r
	confusion[rel][est_rel] = confusion[rel][est_rel] + 1

precision = []
recall = []
f1_score = []

for i in range(1,4):
	for j in range(1,4):
		fid.write(str(confusion[i][j]) + ',')
	fid.write('\n')

for i in range(1,4):
	tp = confusion[i][i]
	fp = confusion[1][i] + confusion[2][i] + confusion[3][i] - tp
	fn = confusion[i][1] + confusion[i][2] + confusion[i][3] - tp
	tn = sum(sum(confusion,[])) - tp - fp - fn

	f = 0
	p = 0
	r = 0
	if (tp + fp) > 0:
		p = tp / (tp + fp)
	if (tp + fn) > 0:
		r = tp / (tp + fn)
	if (p + r) > 0:
		f = 2 * p * r / (p + r)
	a = (tp + tn) / (tp + tn + fp + fn)
	precision.append(p)
	recall.append(r)
	f1_score.append(f)
	print(i,f,p,r,a)
	
	fid.write(str(i) + ':' + str(f) + ',' + str(p) + ',' + str(r) + ',' + str(a) + '\n')

p = sum(precision) / 3
r = sum(recall) / 3
f = sum(f1_score) / 3
a = (confusion[1][1] + confusion[2][2] + confusion[3][3]) / sum(sum(confusion,[]))
print(4,f,p,r,a)
fid.write('4:' + str(f) + ',' + str(p) + ',' + str(r) + ',' + str(a) + '\n')

fid.close()

