function [U,dJ] = make_assignments(D,N,k,alpha,beta)

alphaN = round(alpha*N);
betaN = round(beta*N);

%% Make (N-betaN_r) assignments
[dist,ind] = min(D,[],2);
dnk = [dist (1:N)' ind]; % N by 3 matrix (distance node min_k)
sorted_dnk = sortrows(dnk,1);
sorted_d = sorted_dnk(:,1);
sorted_n = sorted_dnk(:,2);
sorted_k = sorted_dnk(:,3);
numAssign = N-betaN;
dJ = sum(sorted_d(1:numAssign));
U = sparse(sorted_n(1:numAssign), sorted_k(1:numAssign), ones(numAssign,1), N, k);
temp=[sorted_n(1:numAssign), sorted_k(1:numAssign)];
for w=1:numAssign
    D(temp(w,1),temp(w,2))=Inf;
end

%% Make (alphaN + betaN) assignments
n=0;
while n < (alphaN + betaN)
    min_d = min(min(D));
    dJ = dJ+min_d;
    [i_star, j_star] = find(D==min_d);
    U(i_star(1),j_star(1)) = 1; % assign
    D(i_star(1),j_star(1)) = Inf; % don't consider this assignment again
    n=n+1;
end

end

